<?php

/****************************************/
// :
// ==== : LogicBoard
// ==== :   (ShapeShifter)
// ==== Copyright     2011
// ====     
// ====  : http://logicboard.ru

/****************************************/

if (! defined ( 'LogicBoard' ))
{
	@include '../../logs/save_log.php';
	exit ( "Error, wrong way to file.<br><a href=\"/\">Go to main</a>." );
}

include_once('geshi/geshi.php');

if (!isset($lang_message)) $lang_message = language_forum ("board/lang_message");

function bb_decode($msg, $bb_allowed)
{
    global $cache_config, $lang_message;
    
    if (!$bb_allowed)
        $bb_allowed = array();
    
    if (!count($bb_allowed) OR (count($bb_allowed) AND in_array("b", $bb_allowed)))
    	$msg = preg_replace("#\[b\](.+?)\[/b\]#is", "<strong>\\1</strong>", $msg); //Bold	
        
    if (!count($bb_allowed) OR (count($bb_allowed) AND in_array("i", $bb_allowed)))
        $msg = preg_replace("#\[i\](.+?)\[/i\]#is", "<i>\\1</i>", $msg); //italic
        
    if (!count($bb_allowed) OR (count($bb_allowed) AND in_array("s", $bb_allowed)))
	   $msg = preg_replace("#\[s\](.+?)\[/s\]#is", "<s>\\1</s>", $msg); //S
    
    if (!count($bb_allowed) OR (count($bb_allowed) AND in_array("u", $bb_allowed)))
	   $msg = preg_replace("#\[u\](.+?)\[/u\]#is", "<u>\\1</u>", $msg); //S
    
    if (!count($bb_allowed) OR (count($bb_allowed) AND in_array("center", $bb_allowed)))
        $msg = preg_replace("#\[center\](.+?)\[/center\]#is", "<center>\\1</center>", $msg); //center
    
    if (!count($bb_allowed) OR (count($bb_allowed) AND in_array("size", $bb_allowed)))
	   $msg = preg_replace("#\[size=([0-9]+?)\](.+?)\[/size\]#is", "<font size='\\1'>\\2</font>", $msg); //size
    
    if (!count($bb_allowed) OR (count($bb_allowed) AND in_array("font", $bb_allowed)))
	   $msg = preg_replace("#\[font=([a-z ]+?)\](.+?)\[/font\]#is", "<font style='font-family:\\1'>\\2</font>", $msg); //font-family
    
    if (!count($bb_allowed) OR (count($bb_allowed) AND in_array("color", $bb_allowed)))
	   $msg = preg_replace("#\[color=(\#[0-9ACDEF]+?)\](.+?)\[/color\]#is", "<font style='color:\\1'>\\2</font>", $msg); //Color
    
    if (!count($bb_allowed) OR (count($bb_allowed) AND in_array("quote", $bb_allowed)))
    {
        if(preg_match_all("#\[quote(=((.+?)(\|([0-9\., :]+?))?))?\]#is", $msg, $shadow) == preg_match_all("#\[/quote\]#is", $msg, $shadow))
        {            
            $msg = preg_replace("#\[quote\]#is", "<blockquote class=\"blockquote\"><p><span class=\"titlequote\">".$lang_message['quote_title']."</span><span class=\"textquote\">", $msg); //quote
            $msg = preg_replace("#\[quote(=((.+?)(\|([0-9\., :]+?))?))?\]#is", "<blockquote class=\"blockquote\"><p><span class=\"titlequote\">\\3 (\\5) ".$lang_message['quote_title2']."</span><span class=\"textquote\">", $msg); //quote
    	    $msg = preg_replace("#\[/quote\]#is", "</span></p></blockquote><!--quote -->", $msg); //quote
            $msg = preg_replace("#<blockquote class=\"blockquote\"><p><span class=\"titlequote\">(.+?) \(\) (.+?)</span>#is", "<blockquote class=\"blockquote\"><p><span class=\"titlequote\">\\1 \\2</span>", $msg); //quote
    	} 
    }
    
    if (!count($bb_allowed) OR (count($bb_allowed) AND in_array("youtube", $bb_allowed)))
    {
        $msg = preg_replace("#\[youtube=http://(www\.)?youtube.com/v/(.+?)\]#is", '<object width="480" height="385"><param name="movie" value="http://youtube.com/v/\\2?fs=1"></param><param name="allowFullScreen" value="true"></param><param name="allowscriptaccess" value="always"></param><embed src="http://youtube.com/v/\\2?fs=1" type="application/x-shockwave-flash" allowscriptaccess="always" allowfullscreen="true" width="480" height="385"></embed></object>', $msg); //youtube
	    $msg = preg_replace("#\[youtube=http://(www\.)?youtube.com/watch\?v=(.*?)\]#is", '<object width="480" height="385"><param name="movie" value="http://youtube.com/v/\\2?fs=1"></param><param name="allowFullScreen" value="true"></param><param name="allowscriptaccess" value="always"></param><embed src="http://youtube.com/v/\\2?fs=1" type="application/x-shockwave-flash" allowscriptaccess="always" allowfullscreen="true" width="480" height="385"></embed></object>', $msg); //youtube
        $msg = preg_replace("#\[youtube=http://(www\.)?rutube.ru/tracks/([0-9])+.html\?v=(.*?)\]#is", '<object width="470" height="353"><param name="movie" value="http://video.rutube.ru/\\3"></param><param name="wmode" value="window"></param><param name="allowFullScreen" value="true"></param><embed src="http://video.rutube.ru/\\3" type="application/x-shockwave-flash" wmode="window" width="470" height="353" allowFullScreen="true" ></embed></object>', $msg); //rutube
        $msg = preg_replace("#\[youtube=http://(www\.)?video.rutube.ru/(.*?)\]#is", '<object width="470" height="353"><param name="movie" value="http://video.rutube.ru/\\2"></param><param name="wmode" value="window"></param><param name="allowFullScreen" value="true"></param><embed src="http://video.rutube.ru/\\2" type="application/x-shockwave-flash" wmode="window" width="470" height="353" allowFullScreen="true" ></embed></object>', $msg); //rutube
    }
    
	if (!count($bb_allowed) OR (count($bb_allowed) AND in_array("url", $bb_allowed)))
    {      
        $msg = preg_replace("#(^|\s|>)((http://|https://|ftp://|www\.)\w+[^\s\[\]\<]+)#i", '\\1[url=\\2]\\2[/url]', $msg);
        $msg = preg_replace("#\[url=(\S.+?)\](.+?)\[/url\]#ise", "bb_url('\\1', '\\2')", $msg); //url        
    }
    
    if (!count($bb_allowed) OR (count($bb_allowed) AND in_array("email", $bb_allowed)))
	   $msg = preg_replace("#\[email=([a-z_\.\-0-9]+?@[a-z_\.\-0-9]+?\.[a-z]+?)\](.+?)\[/email\]#is", "<a href='mailto:\\1'>\\2</a>", $msg); //email
    
    if (!count($bb_allowed) OR (count($bb_allowed) AND in_array("img", $bb_allowed)))
    {
        $msg = preg_replace("#\[img=?\](.+?)\[/img\]#ise", "bb_create_img('\\1')", $msg); //img center
    	$msg = preg_replace("#\[img=(left|right|center)+?\](.+?)\[/img\]#ise", "bb_create_img('\\2', '\\1')", $msg); //img left|right
    }
    
    if (!count($bb_allowed) OR (count($bb_allowed) AND in_array("php", $bb_allowed)))
    $msg = preg_replace_callback("#\[php\]([\s\S]+?)\[/php\]#is", "php_syntax", $msg); //php	
    
    if (!count($bb_allowed) OR (count($bb_allowed) AND in_array("javascript", $bb_allowed)))
	$msg = preg_replace_callback("#\[javascript\]([\s\S]+?)\[/javascript\]#is", "javascript_syntax", $msg); //javascript	
    
    if (!count($bb_allowed) OR (count($bb_allowed) AND in_array("html", $bb_allowed)))
	$msg = preg_replace_callback("#\[html\]([\s\S]+?)\[/html\]#is", "html_syntax", $msg); //html	
    
    if (!count($bb_allowed) OR (count($bb_allowed) AND in_array("translite", $bb_allowed)))
	$msg = preg_replace_callback("#\[translite\]([\s\S]+?)\[/translite\]#is", "transliteit", $msg); //translite	   

    if (!count($bb_allowed) OR (count($bb_allowed) AND in_array("spoiler", $bb_allowed)))
    {
        if(preg_match_all("#\[spoiler(=(.+?))?\]#ius", $msg, $shadow) == preg_match_all("#\[/spoiler\]#ius", $msg, $shadow))
        {
            $msg = preg_replace_callback("#\[spoiler(=(.+?))?\]#is", "makespoiler", $msg); //spoiler	
    	    $msg = preg_replace("#\[/spoiler\]#i", "</div></blockquote><!--spoiler -->", $msg); //spoiler
    	}
    }

    if (!count($bb_allowed) OR (count($bb_allowed) AND in_array("smile", $bb_allowed)))
	   $msg = preg_replace("#::([0-9]{3,3})::#i", "<img id='smiles_img' src='{TEMPLATE}/bbcode/smiles/\\1.gif' />", $msg); //smailes
       	
    return $msg;
}

function bb_encode($msg)
{
    global $cache_config, $lang_message;
    
	$msg = preg_replace("#<strong>(.+?)</strong>#is", "[b]\\1[/b]", $msg); //Bold
    $msg = preg_replace("#<b>(.+?)</b>#is", "[b]\\1[/b]", $msg); //Bold	
	$msg = preg_replace("#<i>(.+?)</i>#is", "[i]\\1[/i]", $msg); //italic
	$msg = preg_replace("#<s>(.+?)</s>#is", "[s]\\1[/s]", $msg); //S
	$msg = preg_replace("#<u>(.+?)</u>#is", "[u]\\1[/u]", $msg); //S
	$msg = preg_replace("#<font size='([0-9]+?)'>(.+?)</font>#is", "[size=\\1]\\2[/size]", $msg); //size
	$msg = preg_replace("#<font style='font-family:([a-z ]+?)'>(.+?)</font>#is", "[font=\\1]\\2[/font]", $msg); //font-family
	$msg = preg_replace("#<font style='color:(\#[0-9ACDEF]+?)'>(.+?)</font>#is", "[color=\\1]\\2[/color]", $msg); //Color
    
    $spoiler_title = preg_quote ($lang_message['spoiler_title'], "#");
    
    $pattern = array(
                    "#<blockquote class=\"blockspoiler\"><span class=\"titlespoiler\"><a href='\#' onclick=\"ShowAndHide\('.+?'\); return false;\">".$spoiler_title."</a></span><div id='.+?' style='display:none;' class=\"textspoiler\">#is",
                    "#<blockquote class=\"blockspoiler\"><span class=\"titlespoiler\"><a href='\#' onclick=\"ShowAndHide\('.+?'\); return false;\">(.+?)</a></span><div id='.+?' style='display:none;' class=\"textspoiler\">#is", 
					"#</div></blockquote><!--spoiler -->#i"
                    ); 
       
	$replacement = array( 
                    	'[spoiler]', 
                    	'[spoiler=\\1]', 
                    	'[/spoiler]'); 
    
	$msg = preg_replace($pattern, $replacement, $msg);
       
    $pattern = array(
                    "#<blockquote class=\"blockquote\"><p><span class=\"titlequote\">".$lang_message['quote_title']."</span><span class=\"textquote\">#is",
                    "#<blockquote class=\"blockquote\"><p><span class=\"titlequote\">(.+?) ?(\(([0-9\., :]+?)\))? ".$lang_message['quote_title2']."</span><span class=\"textquote\">#is",
                    "#<blockquote class=\"blockquote\"><p><span class=\"titlequote\">(.+?)</span><span class=\"textquote\">#is",
					"#</span></p><\/blockquote><!--quote -->#i"
                    ); 
                    
   	$replacement = array( 
                        '[quote]',
                    	'[quote=$1|$3]', 
                        '[quote]',
                    	'[/quote]'
                        ); 
    
	$msg = preg_replace($pattern, $replacement, $msg);
          	
	$msg = preg_replace("#\[quote=(.+?)\|\]#is", "[quote=\\1]", $msg); 
    
	$msg = preg_replace("#<a href='mailto:([a-z_\.\-0-9]+?@[a-z_\.\-0-9]+?\.[a-z]+?)'>(.+?)</a>#is", "[email=\\1]\\2[/email]", $msg); //email
    $msg = preg_replace("#<a href=['\"](\S.+?)['\"]\s*(target=\"_blank\")?\s*>(.+?)</a>#ise", "bb_url('\\1', '\\3', false)", $msg); //url
    $msg = preg_replace('#<object width="([0-9]){1,4}" height="([0-9]){1,4}"><param name="movie" value="http://youtube.com/v/(.*?)\?fs=1"></param><param name="allowFullScreen" value="true"></param><param name="allowscriptaccess" value="always"></param><embed src="(.*?)" type="application/x-shockwave-flash" allowscriptaccess="always" allowfullscreen="true" width="([0-9]){1,4}" height="([0-9]){1,4}"></embed></object>#is', '[youtube=http://youtube.com/v/\\3]', $msg); //youtube
    $msg = preg_replace('#<object width="([0-9]){1,4}" height="([0-9]){1,4}"><param name="movie" value="http://video.rutube.ru/(.*?)"></param><param name="wmode" value="window"></param><param name="allowFullScreen" value="true"></param><embed src="(.*?)" type="application/x-shockwave-flash" wmode="window" width="([0-9]){1,4}" height="([0-9]){1,4}" allowFullScreen="true" ></embed></object>#is', '[youtube=http://video.rutube.ru/\\3]', $msg); //youtube
    
    $msg = preg_replace("#<!-- Small_img:([:a-z_\-/\.0-9]+?)\|(left|right|center)? -->(.+?)<!--/Small_img -->#ise", "bb_create_img_back('\\1|\\2')", $msg); //php	
	$msg = preg_replace("#<center><img src='(\S+?)'\s*(class='lb_img')?\s*/></center>#is", "[img]\\1[/img]", $msg); //img center
	$msg = preg_replace("#<img src='(\S+?)' align='(left|right)'\s*(class='lb_img')?\s*/>#is", "[img=\\2]\\1[/img]", $msg); //img left|right
    
    $msg = preg_replace("#<center>(.+?)</center>#is", "[center]\\1[/center]", $msg); //center
    
    $msg = preg_replace("#<img id='smiles_img' src='{TEMPLATE}/bbcode/smiles/([0-9]{3,3})\.gif' />#is", "::\\1::", $msg); //smailes
    
    $msg = preg_replace_callback("#<!-- PHP code -->(.+?)<!--/PHP code -->#is", "php_decode", $msg); //php	
	$msg = preg_replace_callback("#<!-- JS code -->(.+?)<!--/JS code -->#is", "js_decode", $msg); //php	
	$msg = preg_replace_callback("#<!-- HTML code -->(.+?)<!--/HTML code -->#is", "html_decode", $msg); //php
	
	return $msg;
}

function bb_url ($link, $text, $encode = true)
{
    global $cache_config, $cache_group, $member_id, $do, $op;
    
    if ($encode)
    {
        $link = bb_clear_url(trim($link));
        
        if (clean_url($link) != clean_url($cache_config['general_site']['conf_value']))
            $target = "target=\"_blank\"";
        else
            $target = "";
        
       	if(!preg_match( "#^(http|news|https|ed2k|ftp|aim|mms)://|(magnet:?)#", $link ))
            $link = 'http://'.$link;
            
        if ($link == 'http://' )
            return "[url=".$link."]".$text."[/url]";
                        
        if ($target)
        {
            $redirect = true;
            if ($cache_config['link_white_list']['conf_value'])
            {
                $white_list = explode ("\r\n", $cache_config['link_white_list']['conf_value']);
                foreach ($white_list as $white_list_c)
                {
                    if (clean_url($link) == clean_url($white_list_c))
                    {
                        $redirect = false;
                        break;
                    }
                }
            }
            
            if ($redirect)
            {
                if ($do == "users" AND $op == "edit")
                    $link = away_from_here($link, $cache_group[$member_id['user_group']]['g_link_signature']);
                else
                    $link = away_from_here($link, $cache_group[$member_id['user_group']]['g_link_forum']);
            }
        }
        
        return "<a href=\"".$link."\" ".$target.">".$text."</a>";
    }
    else
    {
        if (preg_match("#away\.php\?s\=[http|www](.+?)#is", $link))
        {
            $link = preg_replace("#((.+?)away\.php\?s\=)#is", "", $link);
            $link = away_from_here($link, 1, 0);
            
            return "[url=".$link."]".$text."[/url]";
        }
        
        return "[url=".$link."]".$text."[/url]";
    }
}

function bb_create_img($img, $align = "")
{
    global $cache_config;

    $img = trim($img);
    $img = urldecode($img);
        
    if( preg_match( "#[?&;%<\[\]]#", $img ) )
    {
        if( $align != "" )
            return "[img=" . $align . "]" . $img . "[/img]";
        else
            return "[img]" . $img . "[/img]";
    }
                
    $img = bb_clear_url($img);
        
    if($img == "")
        return;
        
    $img_info = "";
        
    if (!$align OR $align == "center")
        $img_block = "<center><img src='".$img."' class='lb_img' /></center>";
    else
        $img_block = "<img src='".$img."' align='".$align."' class='lb_img' />";

	return $img_block;
}

function bb_clear_url($url)
{
    $url = strip_tags( trim( stripslashes( $url ) ) );
	$url = str_replace( '\"', '"', $url );
	$url = str_replace( "document.cookie", "", $url );
	$url = str_replace( " ", "%20", $url );
	$url = str_replace( "'", "", $url );
	$url = str_replace( '"', "", $url );
	$url = str_replace( "<", "&#60;", $url );
	$url = str_replace( ">", "&#62;", $url );
	$url = preg_replace( "#javascript:#i", "j&#097;vascript:", $url );
	$url = preg_replace( "#data:#i", "d&#097;ta:", $url );
		
	return $url;
}

function bb_create_img_back($img)
{
    global $cache_config;
    
    $img = explode ("|", $img);
    if ($img[1] != "")
        return "[img=".$img[1]."]".$img[0]."[/img]";
    else
        return "[img]".$img[0]."[/img]";
}

function makespoiler($arg)
{
    global $lang_message;
    
	if($arg[2]) $name = $arg[2];
    else $name = $lang_message['spoiler_title'];
	
	$id = md5($arg[3].$name.rand(5,1000));
	
	$divs = "<blockquote class=\"blockspoiler\">";
    $divs.= "<span class=\"titlespoiler\"><a href='#' onclick=\"ShowAndHide('".$id."'); return false;\">".$name."</a></span>"; 
	$divs.= "<div id='".$id."' style='display:none;' class=\"textspoiler\">".$arg[3];

	return $divs;
}

function transliteit($str)
{
    $tr = array(
        "A","B","V","G", "D","E", "J","Z","I",
        "Y","K","L","M","N", "O","P","R","S","T",
        "U","F","H","TS","CH", "SH","SCH","YI",
        "YU","YA",
        "a","b","v","g", "d","e", "j","z","i",
        "y","k","l","m","n", "o","p","r","s","t",
        "u","f","h","ts","ch", "sh","sch","yi",
        "yu","ya"
    );	
    
     $rr = array(
        "A","","","", "","","","","",
        "","","","","","","","","","",
        "","","","","","","","","","",
        "","","","", "","","","","",
        "","","","","", "","","","","",
        "","","","","","","","","",""
    );	
	return str_replace($tr, $rr, $str[1]);
}

function php_syntax($str)
{
	$rtn = str_replace("<br />", "\r", $str[1]);
	$rtn = trim(htmlspecialchars_decode($rtn));
	
	$geshi = new GeSHi($rtn, "php");
	$geshi->enable_keyword_links(false);
	$geshi->set_header_type(GESHI_HEADER_DIV);
	$geshi->enable_line_numbers(GESHI_NORMAL_LINE_NUMBERS);
	$geshi->set_overall_style('font: normal normal 90% monospace; color: #000066; border: 1px solid #d0d0d0; background-color: #f0f0f0;', false);
	
	$geshi->set_header_content('php code:');
	$geshi->set_header_content_style('font-family: sans-serif; color: #808080; font-size: 70%; font-weight: bold; background-color: #f0f0ff; border-bottom: 1px solid #d0d0d0; padding: 2px;');
	
	$rtn = "<!-- PHP code -->";
	$rtn.= $geshi->parse_code();
	$rtn.= "<!--/PHP code -->";
	
	return $rtn."";
}
function php_decode($str)
{
	$str = strip_tags($str[1]);
	$str = preg_replace("#^php code:#", "",$str);
	
	$rtn = "[php]\n".$str."[/php]";
	
	return $rtn;
}

function javascript_syntax($str)
{
	$rtn = str_replace("<br />", "\r", $str[1]);
	$rtn = trim(htmlspecialchars_decode($rtn));
	
	$geshi = new GeSHi($rtn, "javascript");
	$geshi->enable_keyword_links(false);
	$geshi->set_header_type(GESHI_HEADER_DIV);
	$geshi->enable_line_numbers(GESHI_NORMAL_LINE_NUMBERS);
	$geshi->set_overall_style('font: normal normal 90% monospace; color: #000066; border: 1px solid #d0d0d0; background-color: #f0f0f0;', false);
	
	$geshi->set_header_content('JavaScript code:');
	$geshi->set_header_content_style('font-family: sans-serif; color: #808080; font-size: 70%; font-weight: bold; background-color: #f0f0ff; border-bottom: 1px solid #d0d0d0; padding: 2px;');
	
	$rtn = "<!-- JS code -->";
	$rtn.= $geshi->parse_code();
	$rtn.= "<!--/JS code -->";
	
	return $rtn;
}

function js_decode($str)
{
	$str = strip_tags($str[1]);
	$str = preg_replace("#^JavaScript code:#", "",$str);
	
	$rtn = "[javascript]\n".$str."[/javascript]";
	
	return $rtn;	
}

function html_syntax($str)
{
	$rtn = str_replace("<br />", "\r", $str[1]);
	$rtn = trim(htmlspecialchars_decode($rtn));
	
	$geshi = new GeSHi($rtn, "html4strict");
	$geshi->enable_keyword_links(false);
	$geshi->set_header_type(GESHI_HEADER_DIV);
	$geshi->enable_line_numbers(GESHI_NORMAL_LINE_NUMBERS);
	$geshi->set_overall_style('font: normal normal 90% monospace; color: #000066; border: 1px solid #d0d0d0; background-color: #f0f0f0;', false);
	
	$geshi->set_header_content('HTML code:');
	$geshi->set_header_content_style('font-family: sans-serif; color: #808080; font-size: 70%; font-weight: bold; background-color: #f0f0ff; border-bottom: 1px solid #d0d0d0; padding: 2px;');
	
	$rtn = "<!-- HTML code -->";
	$rtn.= $geshi->parse_code();
	$rtn.= "<!--/HTML code -->";
	
	return $rtn;
}

function html_decode($str)
{
	//$str = htmlspecialchars($str[1]);
	
	$str = strip_tags($str[1]);
	$str = preg_replace("#^HTML code:#", "",$str);
	
	$rtn = "[html]".$str."[/html]";
	
	return $rtn;
}

?>